/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.workbench.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.terminal.editor.TerminalEditor;
import com.aptana.terminal.views.TerminalView;
import com.aptana.workbench.WorkbenchPlugin;
import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorLineHyperlink
implements IHyperlink {
    private static final String SCHEME_FILE = "file";
    private Region region;
    private String filepath;
    private int lineNumber;

    public EditorLineHyperlink(Region region, String filepath, int lineNumber) {
        this.region = region;
        this.filepath = filepath;
        this.lineNumber = lineNumber;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return MessageFormat.format("{0}:{1}", this.filepath, this.lineNumber);
    }

    public void open() {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IFileStore store = EFS.getStore((URI)this.getFile().toURI());
            if (store == null) {
                return;
            }
            if (store.fetchInfo().isDirectory()) {
                this.openDirectory(page, store);
                return;
            }
            IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)store);
            this.setEditorToLine(editor);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)WorkbenchPlugin.getDefault(), (Throwable)e);
        }
    }

    protected void openDirectory(IWorkbenchPage page, IFileStore store) throws CoreException {
        IViewReference[] viewRefs;
        URI uri = store.toURI();
        if (!SCHEME_FILE.equals(uri.getScheme())) {
            return;
        }
        File file = store.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
        IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(Path.fromOSString((String)file.getAbsolutePath()));
        if (container == null) {
            IHandlerService service = (IHandlerService)page.getActivePart().getSite().getService(IHandlerService.class);
            ICommandService commandService = (ICommandService)page.getActivePart().getSite().getService(ICommandService.class);
            Command command = commandService.getCommand("com.aptana.ui.command.ShowInFileManager");
            ParameterizedCommand pc = ParameterizedCommand.generateCommand((Command)command, null);
            ArrayList<IFileStore> list = new ArrayList<IFileStore>();
            list.add(store);
            EvaluationContext context = new EvaluationContext(service.getCurrentState(), list);
            context.addVariable("showInSelection", (Object)new StructuredSelection(list));
            try {
                service.executeCommandInContext(pc, null, (IEvaluationContext)context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        IViewReference[] iViewReferenceArray = viewRefs = page.getViewReferences();
        int n = viewRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if ("com.aptana.explorer.view".equals(ref.getId())) {
                IViewPart part = (IViewPart)ref.getPart(false);
                if (part != null && part instanceof ISetSelectionTarget) {
                    ISetSelectionTarget target = (ISetSelectionTarget)part;
                    target.selectReveal((ISelection)new StructuredSelection((Object)container));
                }
                if (part != null && part instanceof CommonNavigator) {
                    CommonNavigator navigator = (CommonNavigator)part;
                    CommonViewer treeViewer = navigator.getCommonViewer();
                    treeViewer.expandToLevel((Object)container, 1);
                }
            }
            ++n2;
        }
    }

    private File getFile() {
        if (!this.filepath.startsWith("/")) {
            IViewReference[] viewRefs;
            IEditorReference[] refs;
            IProject project;
            IFile file;
            String activeProject = Platform.getPreferencesService().getString("com.aptana.explorer", "activeProject", null, null);
            if (activeProject != null && (file = (project = ResourcesPlugin.getWorkspace().getRoot().getProject(activeProject)).getFile((IPath)new Path(this.filepath))).exists()) {
                return file.getLocation().toFile();
            }
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorReference[] iEditorReferenceArray = refs = page.getEditorReferences();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                File relative;
                IEditorReference ref = iEditorReferenceArray[n2];
                if ("com.aptana.terminal.TerminalEditor".equals(ref.getId()) && (relative = this.getFileRelativeToWorkingDir(ref.getPart(false))) != null) {
                    return relative;
                }
                ++n2;
            }
            IViewReference[] iViewReferenceArray = viewRefs = page.getViewReferences();
            int n3 = viewRefs.length;
            n = 0;
            while (n < n3) {
                File relative;
                IViewReference ref = iViewReferenceArray[n];
                if ("com.aptana.terminal.views.terminal".equals(ref.getId()) && (relative = this.getFileRelativeToWorkingDir(ref.getPart(false))) != null) {
                    return relative;
                }
                ++n;
            }
        }
        return new File(this.filepath);
    }

    private File getFileRelativeToWorkingDir(IWorkbenchPart part) {
        if (part == null) {
            return null;
        }
        IPath workingDir = null;
        if (part instanceof TerminalView) {
            workingDir = ((TerminalView)part).getWorkingDirectory();
        } else if (part instanceof TerminalEditor) {
            workingDir = ((TerminalEditor)part).getWorkingDirectory();
        }
        if (workingDir == null) {
            return null;
        }
        File relative = workingDir.append(this.filepath).toFile();
        if (relative.exists()) {
            return relative;
        }
        return null;
    }

    private void setEditorToLine(IEditorPart editorPart) throws CoreException {
        if (!(editorPart instanceof ITextEditor)) {
            return;
        }
        if (this.lineNumber > 0) {
            --this.lineNumber;
        }
        if (this.lineNumber == 0) {
            return;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        IDocumentProvider provider = textEditor.getDocumentProvider();
        IEditorInput pInput = editorPart.getEditorInput();
        provider.connect((Object)pInput);
        IDocument document = provider.getDocument((Object)pInput);
        try {
            IRegion line = document.getLineInformation(this.lineNumber);
            textEditor.selectAndReveal(line.getOffset(), line.getLength());
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)WorkbenchPlugin.getDefault(), (Throwable)e);
        }
        provider.disconnect((Object)pInput);
    }
}

